/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskFolderNode;
import filenet.vw.apps.taskman.VWTaskScopePane;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class VWTaskTreeCellRender
extends DefaultTreeCellRenderer {
    private VWTaskScopePane m_scopePane = null;

    public VWTaskTreeCellRender(VWTaskScopePane scopePane) {
        this.setOpaque(true);
        this.m_scopePane = scopePane;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int row, boolean bHasFocus) {
        Component c = super.getTreeCellRendererComponent(tree, value, bSelected, bExpanded, bLeaf, row, bHasFocus);
        JLabel label = null;
        label = c instanceof JLabel ? (JLabel)c : new JLabel();
        VWTaskBaseNode bNode = (VWTaskBaseNode)value;
        switch (bNode.getType()) {
            case 1: {
                if (bSelected) {
                    label.setIcon(VWTaskFolderNode.nodeIconOpen16);
                    break;
                }
                label.setIcon(VWTaskFolderNode.nodeIconClosed16);
                break;
            }
            default: {
                label.setIcon(bNode.getIcon16());
            }
        }
        label.setText(bNode.getName());
        VWAccessibilityHelper.setAccessibility(this, null, label.getText(), label.getText());
        if (bNode == this.m_scopePane.getFocus()) {
            if (this.m_scopePane.hasApplicationFocus()) {
                label.setBackground(SystemColor.textHighlight);
                label.setForeground(SystemColor.textHighlightText);
            } else {
                label.setBackground(SystemColor.lightGray);
                label.setForeground(tree.getForeground());
            }
        } else {
            label.setBackground(tree.getBackground());
            label.setForeground(tree.getForeground());
        }
        return label;
    }
}

